#ifndef __QMUX_UTIL_H__
#define __QMUX_UTIL_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdbool.h>
#include <QmuxTransport.h>

// Return values:
//   0 - succeed
//   1 - invalid argument
//   2 - failed to open transport
int OpenTransport(
	QmuxTransport* ptransport,	// [out]	Pointer to QmuxTransport structure
	char* dev_path,				// [in/out]	Path to Device.  If empty, will be filled
	size_t dev_path_size,		// [in]		Size of buffer dev_path points to
	int* pmode,					// [in/out]	Interface mode, if unknown, will be filled
	int* pif_adapter,			// [out]	adapter interface.  Invalid for USB only
	bool valid,					// [in]		Valid preconditions
	FNSHOWHELP pfnsh,			// [in]		Pointer to ShowHelp function
	const char* pProcName,		// [in]		Process name to be passed to pfhsh
	bool showhelp);				// [in]		Always show help flag

#ifdef __cplusplus
} /* extern "C" { */
#endif

#endif // __QMUX_UTIL_H__

